<?php
    $slider->loadMissing('metadata');
    $tabletImage = $slider->getMetaData('tablet_image', true) ?: $slider->image;
    $mobileImage = $slider->getMetaData('mobile_image', true) ?: $tabletImage;

    $sliderAttributes = $sliderAttributes ?? [];
    $sliderAttributes['loading'] = 'eager';
    $sliderAttributes['fetchpriority'] = 'high';

    $defaultImage = RvMedia::getDefaultImage();
?>

<?php if($slider->link): ?>
    <a href="<?php echo e(url($slider->link)); ?>">
<?php endif; ?>
    <picture>
        <source
            srcset="<?php echo e(RvMedia::getImageUrl($slider->image, null, false, $defaultImage)); ?>"
            media="(min-width: 1200px)"
        />
        <source
            srcset="<?php echo e(RvMedia::getImageUrl($tabletImage, null, false, $defaultImage)); ?>"
            media="(min-width: 768px)"
        />
        <source
            srcset="<?php echo e(RvMedia::getImageUrl($mobileImage, null, false, $defaultImage)); ?>"
            media="(max-width: 767px)"
        />
        <?php echo e(RvMedia::image($slider->image, $slider->title, attributes: $sliderAttributes)); ?>

    </picture>
<?php if($slider->link): ?>
    </a>
<?php endif; ?>

<?php
    unset($sliderAttributes);
?>
<?php /**PATH /home/revampsco/public_html/platform/themes/shofy/partials/shortcodes/simple-slider/includes/image.blade.php ENDPATH**/ ?>