<?php
    $cols = (int) ($shortcode->items_per_view ?? 0);
    $cols = $cols > 0 ? $cols : 5;
    $cols = min(max($cols, 1), 6);
?>

<section class="tp-product-category pt-60 pb-15"
    <?php if($shortcode->background_color): ?> style="background-color: <?php echo e($shortcode->background_color); ?> !important;" <?php endif; ?>>
    <div class="container">
        <?php echo Theme::partial('section-title', compact('shortcode')); ?>

        <style>
            /* Force rectangle cards in list style */
            .tp-product-category .tp-product-category-thumb {
                aspect-ratio: 4 / 3;
                overflow: hidden;
                border-radius: 5px !important;
                border: 1px solid var(--tp-grey-3, #cad4db);
                padding: 5px;
            }

            /* Override theme's circular anchor wrapper */
            .tp-product-category .tp-product-category-thumb a {
                width: 100% !important;
                height: 100% !important;
                border-radius: 10px !important;
                background: none !important;
                display: block;
            }

            .tp-product-category .tp-product-category-thumb img {
                width: 100%;
                height: 100%;
                object-fit: cover;
                border-radius: 10px !important;
                transition: filter .2s ease-in-out, transform .2s ease-in-out;
            }

            /* Hover: emphasize border + darken image */
            .tp-product-category .tp-product-category-item:hover .tp-product-category-thumb {
                border-color: var(--tp-common-black, #010f1c);
            }

            .tp-product-category .tp-product-category-item:hover .tp-product-category-thumb img {
                filter: brightness(0.6);
            }
        </style>
        <div class="row row-cols-xl-<?php echo e($cols); ?> row-cols-lg-<?php echo e($cols); ?> row-cols-md-4 row-cols-2">
            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col">
                    <div class="tp-product-category-item text-center mb-40">
                        <div class="tp-product-category-thumb fix">
                            <a href="<?php echo e($category->url); ?>" title="<?php echo e($category->name); ?>">
                                <?php echo e(RvMedia::image($category->image, $category->name)); ?>

                            </a>
                        </div>
                        <div class="tp-product-category-content">
                            <h3 class="tp-product-category-title">
                                <a href="<?php echo e($category->url); ?>" title="<?php echo e($category->name); ?>"><?php echo e($category->name); ?></a>
                            </h3>
                            <?php if($shortcode->show_products_count): ?>
                                <p>
                                    <?php if($category->count_all_products === 1): ?>
                                        <?php echo e(__('1 product')); ?>

                                    <?php else: ?>
                                        <?php echo e(__(':count products', ['count' => number_format($category->count_all_products)])); ?>

                                    <?php endif; ?>
                                </p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>
<?php /**PATH /home/revampsco/public_html/platform/themes/shofy/partials/shortcodes/ecommerce-categories/list.blade.php ENDPATH**/ ?>