@if ($category->hasPdf())
    <div class="tp-category-pdf-download-section mb-40">
        <div class="tp-category-pdf-download-wrapper">
            <div class="tp-category-pdf-download-card">
                <div class="tp-category-pdf-download-icon">
                    <x-core::icon name="ti ti-file-type-pdf" class="pdf-icon" />
                </div>
                <div class="tp-category-pdf-download-content">
                    <h4 class="tp-category-pdf-download-title">{{ $category->getPdfTitle() }}</h4>
                    @if ($category->getPdfDescription())
                        <p class="tp-category-pdf-download-description">{{ $category->getPdfDescription() }}</p>
                    @endif
                </div>
                <div class="tp-category-pdf-download-action">
                    <a href="{{ $category->getPdfUrl() }}" class="tp-btn tp-btn-primary tp-category-pdf-download-btn"
                        target="_blank" download>
                        <x-core::icon name="ti ti-download" class="me-2" />
                        {{ trans('plugins/ecommerce::product-categories.pdf.download') }}
                    </a>
                </div>
            </div>
        </div>
    </div>

    <style>
        .tp-category-pdf-download-section {
            margin-bottom: 2.5rem;
        }

        .tp-category-pdf-download-card {
            display: flex;
            align-items: center;
            gap: 1rem;
            padding: 1.5rem;
            background: #f8f9fa;
            border: 1px solid #dee2e6;
            border-radius: 8px;
            transition: all 0.3s ease;
        }

        .tp-category-pdf-download-card:hover {
            background: #e9ecef;
            border-color: #adb5bd;
        }

        .tp-category-pdf-download-icon {
            flex-shrink: 0;
        }

        .tp-category-pdf-download-icon .pdf-icon {
            font-size: 2.5rem;
            color: #dc3545;
        }

        .tp-category-pdf-download-content {
            flex: 1;
        }

        .tp-category-pdf-download-title {
            margin: 0 0 0.5rem 0;
            font-size: 1.25rem;
            font-weight: 600;
            color: #212529;
        }

        .tp-category-pdf-download-description {
            margin: 0;
            font-size: 0.875rem;
            color: #6c757d;
        }

        .tp-category-pdf-download-action {
            flex-shrink: 0;
        }

        .tp-category-pdf-download-btn {
            display: inline-flex;
            align-items: center;
            padding: 0.75rem 1.5rem;
            background: var(--tp-theme-primary);
            color: var(--tp-common-white);
            text-decoration: none;
            border-radius: 6px;
            font-weight: 500;
            transition: background-color 0.3s ease;
        }

        .tp-category-pdf-download-btn:hover {
            background: var(--tp-common-black);
            color: var(--tp-common-white);
            text-decoration: none;
        }

        @media (max-width: 768px) {
            .tp-category-pdf-download-card {
                flex-direction: column;
                text-align: center;
                gap: 1rem;
            }

            .tp-category-pdf-download-content {
                text-align: center;
            }
        }
    </style>
@endif
